 ; Ŀ
 ;   Sycomp - check for changes to atomlist.                               
 ;   Copyright 1994, 2008 by Rocket Software Ltd.                          
 ;                                                                         
 ; 

 ; Ŀ
 ;   Bottle - write a boxed file header.                                   
 ;   Takes no prisoners, returns nothing.                                  
 ;   Correction - takes one argument, a filename.                          
 ;   Further correction - takes another argument, list of strings to       
 ;   write, each on its own line.                                          
 ; 
 (DEFUN BOTTLE (lognam strlst / aa bb cc thestr newlst fn)
  (setq aa "")
  (setq bb (strcat " " aa aa ""))
  (setq cc (strcat " " aa aa ""))
  (while (setq thestr (car strlst))
         (setq strlst (cdr strlst))
         (setq thestr (strcat "   " thestr))
         (while (< (strlen thestr) 76) (setq thestr (strcat thestr " ")))
         (setq thestr (strcat thestr ""))
         (setq newlst (append newlst (list thestr))))
  (setq fn (open lognam "w"))
  (princ bb fn)
  (while (setq thestr (car newlst))
         (setq newlst (cdr newlst))
         (princ (strcat "\n" thestr) fn))
  (princ (strcat "\n" cc) fn)
  (close fn))
 ; Ŀ
 ;   Bottle end.                                                           
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   a list of the (possibly modified) target string and the number of     
 ;   changes made.                                                         
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug end.                                                             
 ; 

 ; Ŀ
 ;   Fsxt - read a line from a file (a list written to a file with print)  
 ;   and make it back into a list.                                         
 ;   The list is made with Relish, which returns a list, so the full       
 ;   list:file:list cycle adds one more layer of listing, thus caadr must  
 ;   be used on the result: cadr to extract the list from the (now empty)  
 ;   string and list list, and car to remove the outer list.               
 ;   Modified: the file now consists of multiple lines, each containing    
 ;   one list, and a header.  Also want to allow for comments.             
 ; 
 (DEFUN FSXT (filnam / fn str lla)
  (if (setq fn (open filnam "r"))
      (progn
           (while (setq str (read-line fn))
                  (while (and (/= (substr str 1 1) "")
                              (= (substr str 1 1) " "))
                         (setq str (substr str 2)))
                  (if (null (member (substr str 1 1) (list ";" "" "" "")))
                      (progn
 ; Ŀ
 ;   Replace double backslashes in the string with backslashes.            
 ; 
                           (setq str (car (chug "\\\\" "\\" str)))
                           (setq lla (append lla (cadr (relish str)))))))
           (close fn))
      (setq lla ()))
 lla)
 ; Ŀ
 ;   Fsxt end.                                                             
 ; 

 ; Ŀ
 ;   Relish - make a text string into a list.                              
 ;   Takes one argument, a string.                                         
 ;   Returns the remainder of the string and a list.                       
 ; 
 (DEFUN RELISH (str / curvar achar strand nulst stop)
  (setq curvar "")
  (while (and (null stop) (> (strlen str) 0))
         (setq achar (substr str 1 1))
         (setq str (substr str 2))
         (cond ((= achar "(")
                (setq strand (relish str))
                (setq nulst (append nulst (list (cadr strand))))
                (setq str (car strand)))
               ((= achar ")")
                (while (= (substr str 1 1) " ")
                       (setq str (substr str 2)))
                 (setq stop t))
               ((= achar " ")
                (setq curvar (read curvar))
                (setq nulst (append nulst (list curvar)))
                (setq curvar ""))
               ((= achar "\"")
                (if (not (member curvar '("" " ")))
                    (progn
                         (setq curvar (read curvar))
                         (setq nulst (append nulst (list curvar)))
                         (setq curvar "")))
                (while (and (setq achar (substr str 1 1))
                            (setq str (substr str 2))
                            (/= achar "")
                            (/= achar "\""))
                       (if (/= achar "\"")
                           (setq curvar (strcat curvar achar))))
                (setq nulst (append nulst (list curvar)))
                (setq str (substr str 2))
                (setq curvar ""))
               (t
                (setq curvar (strcat curvar achar)))))
  (if (/= curvar "") 
      (setq nulst (append nulst (list (read curvar)))))
 (list str nulst))
 ; Ŀ
 ;   Relish end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Sycomp: variables against the list of previous values.     
 ;   Argument: Atomls, a list: ((name value type) ...)                     
 ;   Calls nothing, Returns nothing.                                       
 ;   Prints the name and value of any changed variable.                    
 ; 
 (DEFUN SYCOMP (atomls / curent num sub atom0 val0 match)
  (setq curent (sysget))
  (setq num 0)
  (while (setq sub (nth num atomls))
         (setq num (1+ num))
         (setq atom0 (car sub))
         (setq val0 (cadr sub))
         (setq match (assoc atom0 curent))
         (if (and (not (equal (cadr match) (cadr sub)))
                  (/= atom0 "ATOM0")
                  (/= atom0 "VAL0")
                  (/= atom0 "SUB")
                  (/= atom0 "ATOMLS")
                  (/= atom0 "ATOMLST"))
             (progn
 ; Ŀ
 ;   There are three possible conditions (ignoring earthquakes).  If are   
 ;   here then condition 1. (no change to variable) has not occurred.      
 ;   So: either 2. the variable is new or 3. its value has been changed.   
 ; 
                  (cond ((null sub)                    ; new
                         (write-line "")
                         (princ "New variable: ")
                         (princ (car match))
                         (princ "  Value: ")
                         (princ (cadr match)))
                        (t                             ; changed
                         (write-line "")
                         (princ "Changed: ")
                         (princ atom0)
                         (princ "\n  Old value: ")
                         (princ (cadr sub))
                         (princ "\n  New value: ")
                         (princ (cadr match)))))))
 (princ))
 ; Ŀ
 ;   Subroutine Sycomp end.                                                
 ; 

 ; Ŀ
 ;   Sysget - get a list of the current values of all variables, etc.      
 ;   Takes no arguments.                                                   
 ;   Calls nothing, returns a list.                                        
 ; 
 (DEFUN SYSGET (/ atlist len atom1 atomval atomtyp lst)
  (setq atomlst ())
  (setq atlist (atoms-family 0))
  (setq len (1- (length atlist)))
  (while (>= len 0)
         (setq atom1 (nth len atlist))
         (if (zerop (rem len 100))
             (grtext -2 (itoa len)))
         (setq atomval (eval atom1))
         (setq atomtyp (type atomval))
         (setq lst (list (vl-princ-to-string atom1)
                         (vl-princ-to-string atomval)
                         (vl-princ-to-string atomtyp)))  ; maybe superfluous
         (setq atomlst (append atomlst (list lst)))
         (setq len (1- len)))
 atomlst)
 ; Ŀ
 ;   Sysget end.                                                           
 ; 

 ; Ŀ
 ;   Sysave - save the current values of all variables, etc. to a list     
 ;   and also to a text file.                                              
 ; 
 (DEFUN C:SYSAVE (/ filnam len tlis fn num sub)
  (setq atomlst (sysget))
 ; Ŀ
 ;   Make a directory path and name string without the extension.          
 ; 
  (setq filnam (strcat (getvar "dwgprefix") (getvar "dwgname")))
  (if (= (substr (strcase filnam t) (- (setq len (strlen filnam)) 3)) ".dwg")
      (setq filnam (substr filnam 1 (- len 4))))
  (setq filnam (strcat filnam ".vars"))
  (setq tlis (list (strcat "Variable data for " (getvar "dwgname") ".")
                   "This file was created by Scomp/Ssave.lsp."
                   ""))
  (bottle filnam tlis)
 ; Ŀ
 ;   Save the data to the file.                                            
 ; 
  (setq fn (open filnam "a"))
  (setq num 0)
  (while (setq sub (nth num atomlst))
         (print sub fn)
         (setq num (1+ num)))
  (close fn)
 (princ))
 ; Ŀ
 ;   Sysave end.                                                           
 ; 

 ; Ŀ
 ;   Sycomp: check the variables against the previous values, indicate     
 ;   changes.                                                              
 ; 
 (DEFUN C:SYCOMP ()
  (if atomlst
      (sycomp atomlst)
      (prompt "You must run Sysave first.  And then change something."))
 (princ))
 ; Ŀ
 ;   Sycomp end.                                                           
 ; 

 ; Ŀ
 ;   Sycompf: check the current state of variables against values from     
 ;   a file made by Sysave, indicate changes.                              
 ; 
 (DEFUN C:SYCOMPF (/ filnam atomlst)
 ; Ŀ
 ;   Ask the user for a sysvar data file made by Sysave.                   
 ; 
  (setq filnam (getfiled "Sysvar Data File" (getvar "dwgprefix") "vars" 6))
 ; Ŀ
 ;   Read it back into a list of lists of strings.                         
 ; 
  (setq atomlst (fsxt filnam))
  (sycomp atomlst)
 (princ))